/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.compat.crafttweaker;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.crafttweaker.api.zencode.IScriptLoadSource;
import com.mrbysco.structurecompass.compat.gamestages.GameStagesHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class ActionSetStructureStaging
implements IUndoableAction {
    private final ResourceLocation structureLocation;
    private final String[] stages;

    public ActionSetStructureStaging(ResourceLocation structureLocation, String[] stages) {
        this.structureLocation = structureLocation;
        this.stages = stages;
    }

    public boolean shouldApplyOn(IScriptLoadSource source) {
        return true;
    }

    public void undo() {
        Set strings = GameStagesHelper.STRUCTURE_STAGES.computeIfAbsent(this.structureLocation, s -> new HashSet());
        Arrays.asList(this.stages).forEach(strings::remove);
    }

    public String describeUndo() {
        return "Removing the stages \"" + Arrays.toString(this.stages) + "\" of structure: \"" + this.structureLocation + "\"";
    }

    public void apply() {
        Set strings = GameStagesHelper.STRUCTURE_STAGES.computeIfAbsent(this.structureLocation, s -> new HashSet());
        strings.addAll(Arrays.asList(this.stages));
    }

    public String describe() {
        return "Set the stages of structure: \"" + this.structureLocation + "\" to: " + Arrays.toString(this.stages);
    }
}

